#include "stm32f10x.h"
#include "delay.h"

static u8  fac_us=0;//usʱ
static u16 fac_ms=0;//msʱ

//ʼӳٺ
//ʹucosʱ,˺ʼucosʱӽ
//SYSTICKʱӹ̶ΪHCLKʱӵ1/8
//SYSCLK:ϵͳʱ
void DelayInit()	 
{
	SysTick_CLKSourceConfig(SysTick_CLKSource_HCLK_Div8);	//ѡⲿʱ  HCLK/8
	fac_us=SystemCoreClock/8000000;	//Ϊϵͳʱӵ1/8  
	fac_ms=(u16)fac_us*1000;//ucos,ÿmsҪsystickʱ   

}								    

//ʱnus
//nusΪҪʱus.		    								   
void DelayUs(unsigned long nus)
{		
	u32 temp;	    	 
	SysTick->LOAD=nus*fac_us; //ʱ	  		 
	SysTick->VAL=0x00;        //ռ
	SysTick->CTRL|=SysTick_CTRL_ENABLE_Msk ;          //ʼ	 
	do
	{
		temp=SysTick->CTRL;
	}
	while(temp&0x01&&!(temp&(1<<16)));//ȴʱ䵽   
	SysTick->CTRL&=~SysTick_CTRL_ENABLE_Msk;       //رռ
	SysTick->VAL =0X00;       //ռ	 
}
//ʱnms
//עnmsķΧ
//SysTick->LOADΪ24λĴ,,ʱΪ:
//nms<=0xffffff*8*1000/SYSCLK
//SYSCLKλΪHz,nmsλΪms
//72M,nms<=1864 
void DelayMs(unsigned int nms)
{	 		  	  
	u32 temp;		   
	SysTick->LOAD=(u32)nms*fac_ms;//ʱ(SysTick->LOADΪ24bit)
	SysTick->VAL =0x00;           //ռ
	SysTick->CTRL|=SysTick_CTRL_ENABLE_Msk ;          //ʼ  
	do
	{
		temp=SysTick->CTRL;
	}
	while(temp&0x01&&!(temp&(1<<16)));//ȴʱ䵽
	SysTick->CTRL&=~SysTick_CTRL_ENABLE_Msk;       //رռ
	SysTick->VAL =0X00;       //ռ
}

void DelayS(unsigned int ns)//ʱ
{
	unsigned char i;
	for(i=0;i<ns;i++)
	{
		DelayMs(1000);
	}
}
